

clear all

% ----------------------------------------------------------------------- %
% Complete the following code:
% Modify here to your folder
cd 'C:\Users\ylin\OneDrive\AQUA_workstation\TA\MICRO-429 Metrology Practicals\data\counters'


% Modify here add names of your data

CR_ND4_5 = importdata('ND4.5.txt').data;
CR_ND4 = importdata('ND4.txt').data;
CR_ND3_5 = importdata('ND3.5.txt').data;
CR_ND3 = importdata('ND3.txt').data;


% -------------------------------- END ---------------------------------- %


% ----------------------------------------------------------------------- %
% The following code calculate and concatenate the mean and standard
% deviation of counts with different count rates. The No. 5 pixel is deemed
% as hot pixel and is excluded. Please modify the following code and 
% exclude the hot pixels of your sensor.

mm = [
    mean(CR_ND4_5([1:4 , 6:end],2))
    mean(CR_ND4([1:4 , 6:end],2))
    mean(CR_ND3_5([1:4 , 6:end],2))
    mean(CR_ND3([1:4 , 6:end],2))
];

ss = [
    std(CR_ND4_5([1:2 , 6:end],2))
    std(CR_ND4([1:6 , 6:end],2))
    std(CR_ND3_5([1:4 , 6:end],2))
    std(CR_ND3([1:4 , 6:end],2))
];

% -------------------------------- END ---------------------------------- %

% Plot the figures

figure;
plot(CR_ND3(:,1),CR_ND3(:,2),'-o','LineWidth',3,'MarkerSize',10)
grid on


figure;
loglog(mm, mm./ss,'-o','LineWidth',3,'MarkerSize',10)
hold on
loglog(mm, sqrt(mm),'-x','LineWidth',3,'MarkerSize',10)
grid on

legend('Measured SNR','Theoretical SNR')
xlabel('Count rate [cps]')
ylabel('SNR')
